package com.bxm.adx.common.adapter;

/**
 * @author allen
 * @date 2020-09-25
 * @since 1.0
 */
public final class AdxContextFactory {

    private static final ThreadLocal<AdxContext> THREAD_LOCAL = new ThreadLocal<>();

    public static AdxContext init() {
        AdxContext adxContext = new AdxContext();
        return init(adxContext);
    }

    public static AdxContext init(AdxContext adxContext) {
        THREAD_LOCAL.set(adxContext);
        return adxContext;
    }

    public static AdxContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}
