package com.bxm.adx.common.adapter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Maps;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 销售方模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface BidModelAdapter extends ModelAdapter {

    /**
     *
     * @param bytes
     * @return
     */
    BidRequest convert(byte[] bytes);

    /**
     *
     * @param e
     * @param bidRequest
     * @return
     */
    byte[] convert(BidResponse e, BidRequest bidRequest);

    /**
     * 自定义响应给接入方的 {@code Header} 响应。
     * @return 响应头
     */
    default Map<String, String> headers() {
        return Maps.newHashMap();
    }

    /**
     * 不竞价的状态码
     * @return 默认：200
     */
    default int statusCode() {
        return HttpStatus.OK.value();
    }

    /**
     * 如果发生异常或不竞价的情况，有可能接入方有特殊的要求返回的格式，那么可以实现该接口。
     * @param request 请求模型
     * @param e
     * @return 异常或不竞价情况下响应内容字节码。
     */
    default byte[] rejectByException(BidRequest request, Exception e) {
        return new byte[0];
    }

    /**
     * 媒体id
     * @return
     */
    default AdxConstants.Media media() {
        return AdxConstants.Media.Unknown;
    }

    /**
     * 后置处理 凤凰需要
     *
     * @param bidRequest
     * @param position
     */
    default BidRequest reBuildBidRequest(BidRequest bidRequest, Position position) {
        return bidRequest;
    }

    /**
     * 二段请求获取创意
     *
     * @param bytes
     * @return
     */
    default byte[] creative(byte[] bytes) {
        return new byte[]{};
    }

    /**
     * 二段请求自定义素材材响应
     *
     * @param data
     * @param response
     */
    default void customCreativeHttpResponse(byte[] data, HttpServletResponse response) {
        if (data == null || data.length == 0) {
            response.setStatus(204);
        }
    }

    /**
     * 转换request格式为可读
     *
     * @param request
     * @return
     */
    default String convertSspRequest(byte[] request) {
        return request == null ? null : new String(request);
    }

    /**
     * 转换response格式为可读
     *
     * @param response
     * @return
     */
    default String convertSspResponse(byte[] response) {
        return response == null ? null : new String(response);
    }
}
