package com.bxm.adx.common.buy.buyer;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.micrometer.BuyerMeter;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 抽象的买家
 *
 * @author allen
 * @since 2019-12-13
 */
public abstract class AbstractBuyer implements Buyer {

    protected DspService dspService;
    protected BuyerMeter buyerMeter;

    /**
     * 请求买家竞拍
     * @param requestBody 买家请求内容
     * @return 买家竞拍结果
     */
    protected abstract byte[] request(byte[] requestBody);

    @Override
    public byte[] offer(byte[] request) {
        return this.request(request);
    }

    @Override
    public Dsp getDsp() {
        return dspService.get(getCode());
    }

    @Autowired
    public void setDspService(DspService dspService) {
        this.dspService = dspService;
    }

    @Autowired
    public void setBuyerMeter(BuyerMeter buyerMeter) {
        this.buyerMeter = buyerMeter;
    }
}
