package com.bxm.adx.common.buy.dispatcher;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DispatcherPriceConfig implements Serializable {
    private static final long serialVersionUID = 1850751998700070857L;

    private Long id;

    /**
     * dsp配置id
     */
    private Long positionDspPosId;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 开始时段
     */
    private Integer startTime;

    /**
     * 结束时段
     */
    private Integer endTime;

    /**
     * 出价系数
     */
    private BigDecimal biddingCoefficient;

    /**
     * 利润率
     * profitMargin%
     */
    private BigDecimal profitMargin;

    /**
     * 广告主出价折扣分割线
     * 单位元
     */
    private BigDecimal priceSplit;

    /**
     * 0-price_split时的折扣
     */
    private BigDecimal ltPriceDiscountFactor;

    /**
     * price_split以上时的折扣
     */
    private BigDecimal gtPriceDiscountFactor;

    /**
     * 分时段固价出价CPM
     */
    private BigDecimal dspCpmPrice;
}
