package com.bxm.adx.common.buy.dispatcher.abtest.cached;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author fgf
 * @date 2022/12/7
 **/
@Configuration
@Slf4j
public class DispatcherConfigCached implements DispatcherABConfigChangeHandler {
    /**
     * 广告位分桶对应configId集合
     * <pre>
     * |---------------------|-----------------------------|
     * |    Key              | Value                       |
     * |---------------------|-----------------------------|
     * | {positionId-bucket} | {configId}                  |
     * |---------------------|-----------------------------|
     * </pre>
     */
    private final ConcurrentHashMap<String, String> userBucketMap = new ConcurrentHashMap<>();

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }

            String positionId = latest.getPositionId();

            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                String configId = dispatcherConfig.getId();
                if (Objects.isNull(configId)) {
                    continue;
                }

                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) {
                    continue;
                }

                Integer start = dispatcherConfig.getStart();
                Integer end = dispatcherConfig.getEnd();
                if (Objects.isNull(start) || Objects.isNull(end)) {
                    continue;
                }

                for (int i = start; i <= end; i++) {
                    userBucketMap.put(buildKey(positionId, i), configId);
                }
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        String positionId = old.getPositionId();
        for (int i = DispatcherConfig.startInclusive; i < DispatcherConfig.endExclusive; i++) {
            userBucketMap.remove(buildKey(positionId, i));
        }
    }

    public Long getConfigId(String positionId, int bucket) {
        return Long.parseLong(userBucketMap.get(buildKey(positionId, bucket)));
    }

    private static String buildKey(String positionId, int bucket) {
        return positionId + "-" + bucket;
    }
}
