package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.WhiteBlackSetRule;
import com.bxm.adx.common.sell.request.User;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2023/3/13
 **/
@Slf4j
@Configuration
public class InstalledAppFilter implements DispatcherFilter<Dispatcher> {
    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        User user = context.getRequest().getUser();
        List<String> installList = Objects.isNull(user) ? null : user.getInstalled_app_list();
        Collection<Dispatcher> dispatchers = context.getValues();
        Set<Dispatcher> removes = dispatchers.stream().filter(
                dispatcher -> limitedByInstallAppList(dispatcher, installList)
        ).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    @Override
    public int getOrder() {
        return 2;
    }

    /**
     * app已安装包名定向
     *
     * @param dispatcher
     * @param installList
     * @return
     */
    private boolean limitedByInstallAppList(Dispatcher dispatcher, List<String> installList) {
        Rule rule = dispatcher.getInstalledAppDirect();
        if (Objects.isNull(rule)) {
            return false;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (CollectionUtils.isEmpty(installList)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", dispatcher.getId(), "installApp-white-empty");
                }
                return true;
            } else {
                Collection<String> result = CollectionUtils.intersection(installList, set);
                if (CollectionUtils.isNotEmpty(result)) {
                    return false;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("rm dispatcher {} by : {}", dispatcher.getId(), "installApp-white-empty");
                    }
                    return true;
                }
            }
        } else {
            if (CollectionUtils.isEmpty(installList)) {
                return false;
            } else {
                Collection<String> result = CollectionUtils.intersection(installList, set);
                if (CollectionUtils.isNotEmpty(result)) {
                    if (log.isDebugEnabled()) {
                        log.debug("rm dispatcher {} by : {}", dispatcher.getId(), "installApp-black");
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
}
