package com.bxm.adx.common.buy.positionassembly;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

/**
 *
 * For cache pushable
 *
 * <pre>
 * name = "POSITION_ASSEMBLY"
 * parameters = {positionId=$positionId}
 * byte[] = PositionAssembly object to json bytes
 * </pre>
 * @author zhengwangeng
 * @since 2020-2-20
 */
@Component
@CachePush("POSITION_ASSEMBLY")
public class PositionAssemblyDaoImpl implements PositionAssemblyDao, Pushable {

    private final Fetcher fetcher;
    private final Updater updater;

    public PositionAssemblyDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public PositionAssembly getByPositionId(String positionId) {
        return fetcher.fetch(getKeyGenerator(positionId), PositionAssembly.class);
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        PositionAssembly positionAssembly = JsonHelper.convert(data, PositionAssembly.class);

        updater.remove(getKeyGenerator(positionId));
        if(null != positionAssembly){
            updater.update(getKeyGenerator(positionId), positionAssembly);
        }
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build("ADX", "POSITION_ASSEMBLY", "POSITION_ID", value);
    }
}
