package com.bxm.adx.common.cipher;

/**
 * 加解密服务
 *
 * @author allen
 * @date 2020-09-25
 * @since 1.0
 */
public interface CipherService {

    /**
     * 使用普通的 {@code AES} 对称加密方式对 {@code content} 进行加密
     * @param content 需要加密的内容
     * @param key 密钥
     * @return 密文，默认对加密后的 {@code byte} 内容进行 {@code Base64} 处理后返回。
     * @see #aesDecrypt(String, String)
     */
    String aesEncrypt(String content, String key);

    /**
     * 使用普通的 {@code AES} 对称加密方式对 {@code encrypt} 进行解密
     * @param encrypt 密文，经过 {@code Base64} 处理后的
     * @param key 密钥
     * @return 明文
     * @see #aesEncrypt(String, String)
     */
    String aesDecrypt(String encrypt, String key);

    /**
     * 为当前密钥生成一个 {@code request_id}，后续可以通过 {@code request_id} 查找到密钥。
     * 注意返回的 {@code request_id} 存在有效期保护
     * @param key 密钥
     * @return request_id
     * @see #getKey(String)
     */
    String generateRequestId(String key);

    /**
     * 根据 {@code requestId} 查找密钥
     * @param requestId request_id
     * @return 密钥
     * @see #generateRequestId(String)
     */
    String getKey(String requestId);
}
