package com.bxm.adx.common.creative;

import lombok.Data;

/**
 * @author allen
 * @since 2019-12-18
 */
@Data
public class Creative {

    public static final byte STATUS_WAIT = 0;
    public static final byte STATUS_PASS = 1;
    public static final byte STATUS_REFUSE = 2;

    public static final byte TYPE_LANDINGPAGE = 1;
    public static final byte TYPE_DOWNLOAD = 2;
    public static final byte TYPE_DEEPLINK = 3;

    private Long id;
    private Long dspId;
    /**
     * DSP创意ID
     */
    private String dspCrtid;
    /**
     * DSP广告主ID
     */
    private String dspAdvtid;
    /**
     * 审核状态
     */
    private Byte auditStatus;
    /**
     * 广告类型
     */
    private Byte type;

    public boolean isEnable() {
        return getAuditStatus() == STATUS_PASS;
    }
}
