package com.bxm.adx.common.creative.replace;

import com.bxm.mccms.facade.model.adx.AdxReplaceCreativeFacadeDTO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;;

/**
 *
 * @author arei
 */
@Slf4j
@CachePush("ADX_REPLACE_CREATIVE")
public class ReplaceCreativeDaoImpl implements ReplaceCreativeDao, Pushable {
    private final DataSyncProducer dataSyncProducer;
    private final ReplaceCreativeCaching replaceCreativeCaching;

    public ReplaceCreativeDaoImpl(DataSyncProducer dataSyncProducer, ReplaceCreativeCaching replaceCreativeCaching) {
        this.dataSyncProducer = dataSyncProducer;
        this.replaceCreativeCaching = replaceCreativeCaching;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("replace creative data = {}", JsonHelper.convert(data, String.class));
        }

        AdxReplaceCreativeFacadeDTO creativeFacadeDTO = JsonHelper.convert(data, AdxReplaceCreativeFacadeDTO.class);
        if (Objects.isNull(creativeFacadeDTO) || Objects.isNull(creativeFacadeDTO.getId())) {
            return;
        }

        String key = creativeFacadeDTO.getClass().getName() + "$" + creativeFacadeDTO.getId();
        dataSyncProducer.post(key, creativeFacadeDTO);
    }

    private KeyGenerator getKeyGenerator(String id) {
        return () -> KeyBuilder.build("ADX", "REPLACE_CREATIVE", id);
    }

    @Override
    public List<ReplaceCreative> queryCreativeListByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<ReplaceCreative> creatives = Lists.newArrayListWithCapacity(ids.size());
        for (Long id : ids) {
            if (Objects.isNull(id)) {
                continue;
            }
            ReplaceCreative replaceCreative = null;
            replaceCreative = replaceCreativeCaching.get(String.valueOf(id));
            if (Objects.isNull(replaceCreative)) {
                if (log.isWarnEnabled()) {
                    log.warn("replace-creative id = {}, not exist", id);
                }
                continue;
            }
            creatives.add(replaceCreative);
        }
        return creatives;
    }
}
