package com.bxm.adx.common.filter;

import lombok.Builder;
import lombok.Data;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2023/3/20
 **/
@Data
@Builder
public class LimitConfig {
    /**
     * 限制类型
     */
    private LimitType type;
    /**
     * 窗口期时长
     */
    private Integer timeWindow;
    /**
     * 时间单位
     */
    private TimeUnit timeUnit;
    /**
     * 限制次数
     */
    private Integer limit;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LimitConfig that = (LimitConfig) o;
        return getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getType());
    }

    public enum LimitType {
        REQUEST(1),
        BID(2),
        SHOW(3),
        CLICK(4),
        ;
        private int type;

        LimitType(int type) {
            this.type = type;
        }

        public static LimitType getLimitType(int type) {
            return Arrays.stream(LimitType.values()).filter(limitType -> limitType.getType() == type).findFirst().orElse(null);
        }

        public int getType() {
            return type;
        }
    }
}
