package com.bxm.adx.common.ingetration;


import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.facade.UserProfile;

import java.util.List;

/**
 * @author allen
 * @date 2020-11-17
 * @since 1.0
 */
public interface UserServiceIntegration {

    UserProfile getUser(DevRequest request);

    /**
     * 获取SDK初始化信息（推荐）<br/>
     *
     * @param request 设备号相关信息
     * @return com.bxm.adx.facade.model.dev.SdkInitCache
     */
    SdkInitCache getSdkInit(DevRequest request);

    /**
     * 获取SDK初始化信息<br/>
     *
     * @param uid @see com.bxm.adx.facade.service.UserService.getUser()
     * @return com.bxm.adx.facade.model.dev.SdkInitCache
     */
    SdkInitCache getSdkInitByUid(String uid);

    /**
     * 获取SDK初始化时的已安装APP包名列表（推荐）<br/>
     * 仅支持安卓<br/>
     *
     * @param request 设备号相关信息
     * @return java.util.List<java.lang.String>
     */
    List<String> getInstalledList(DevRequest request);

    /**
     * 获取SDK初始化时的已安装APP包名列表<br/>
     * 仅支持安卓<br/>
     *
     * @param uid @see com.bxm.adx.facade.service.UserService.getUser()
     * @return java.util.List<java.lang.String>
     */
    List<String> getInstalledListByUid(String uid);

    /**
     * 获取cuid
     * @param appId
     * @param uid
     * @return
     */
    String getCuid(String appId, String uid);
}
