package com.bxm.adx.common.ingetration.feign;

import com.bxm.adx.common.ingetration.UserServiceIntegration;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.facade.UserProfile;
import com.bxm.user.facade.service.UserMappingService;
import com.bxm.user.facade.service.UserService;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import java.util.List;

/**
 * @author allen
 * @date 2020-11-17
 * @since 1.0
 */
@Configuration
@Profile("!standalone")
@EnableFeignClients(basePackages = {"com.bxm.user.facade.service"})
public class FeignUserServiceIntegration implements UserServiceIntegration {

    private final UserService userService;
    private final UserMappingService userMappingService;

    public FeignUserServiceIntegration(UserService userService, UserMappingService userMappingService) {
        this.userService = userService;
        this.userMappingService = userMappingService;
    }

    @Override
    public UserProfile getUser(DevRequest request) {
        return userService.getUser(request);
    }

    @Override
    public SdkInitCache getSdkInit(DevRequest request) {
        return userService.getSdkInit(request);
    }

    @Override
    public SdkInitCache getSdkInitByUid(String uid) {
        return userService.getSdkInitByUid(uid);
    }

    @Override
    public List<String> getInstalledList(DevRequest request) {
        return userService.getInstalledList(request);
    }

    @Override
    public List<String> getInstalledListByUid(String uid) {
        return userService.getInstalledListByUid(uid);
    }
    @Override
    public String getCuid(String appId, String uid) {
        return userMappingService.getByUid(appId, uid, Boolean.TRUE);
    }
}
