package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author fgf
 * @date 2023/1/10
 **/
@Configuration
@Slf4j
public class OfferFactory implements ApplicationListener<ApplicationReadyEvent> {
    private Map<OfferType, Offer> offerMap = new HashMap<>();
    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        Collection<Offer> offerList = event.getApplicationContext().getBeansOfType(Offer.class).values();
        for (Offer offer : offerList) {
            offerMap.put(offer.offerType(), offer);
        }
    }

    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        OfferType offerType = getOfferType(request, dispatcher);
        Offer offer = offerMap.get(offerType);

        Map<Bid, OfferResult> offerResultMap = null;
        if (Objects.isNull(offer)) {
            offerResultMap = new HashMap<>(bids.size());
            for (Bid bid : bids) {
                offerResultMap.put(bid, OfferResult.builder()
                                .offer(bid.getPrice())
                                .chargeType(AdxConstants.ChargeType.CPM)
                        .build());
            }
            return offerResultMap;
        }

        return offer.offer(bids, request, dispatcher);

    }

    private OfferType getOfferType(BidRequest request, Dispatcher dispatcher) {
        Integer avgType = dispatcher.getAvgType();
        if (Objects.isNull(avgType)) {
            //适配旧版本 since 20230522
            BigDecimal avg = dispatcher.getDspAvgPrice();
            if (Objects.isNull(avg)) {
                return OfferType.NONE_Dsp_Avg_Price;
            }
            return OfferType.Dsp_Avg_Price;
        } else {
            switch (avgType) {
                case AdxConstants.DispatcherAvgType.FIXED:
                    return OfferType.Dsp_Avg_Price;
                case AdxConstants.DispatcherAvgType.NONE:
                    return OfferType.NONE_Dsp_Avg_Price;
                case AdxConstants.DispatcherAvgType.FIXED_DISCOUNT:
                    return OfferType.Dsp_Avg_Price_Discount;
                default:
                    log.error("unknown dispatcher {} avg-type {}", dispatcher.getId(), dispatcher.getAvgType());
            }
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
    }
}
