package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferFactory;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author fgf
 * @date 2023/1/10
 **/
@Configuration
public class OfferPriceBuilder implements AdxBidResponseBuilder {
    private final OfferFactory factory;

    public OfferPriceBuilder(OfferFactory factory) {
        this.factory = factory;
    }

    @Override
    public int getOrder() {
        return 4;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest request = attribute.getBidRequest();

        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            Map<Bid, OfferResult> offerResultMap = factory.offer(seatBid.getBid(), request, dispatcher);
            for (Bid bid : seatBid.getBid()) {
                OfferResult result = offerResultMap.get(bid);
                int chargeType = result.getChargeType();
                bid.setCharge_type(chargeType);

                switch (chargeType) {
                    case AdxConstants
                            .ChargeType.CPM:
                        bid.setPrice(result.getOffer());
                        break;
                    case AdxConstants
                            .ChargeType.CPC:
                        bid.setBid(result.getOffer());
                        break;
                    default:
                        bid.setPrice(result.getOffer());
                }
            }
        }
    }
}
