package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 非法bid过滤
 *
 * @author fgf
 * @date 2023/3/1
 **/
@Slf4j
@Configuration
@DealFilterCondition(preview = true)
public class NoBidFilter implements Filter {
    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set<Deal> remove = deals.stream().filter(
                deal -> {
                    Boolean bidSuccess = deal.getBidSuccess();
                    if (Objects.nonNull(bidSuccess)) {
                        return !bidSuccess;
                    }
                    BidResponse response = deal.getBidResponse();
                    if (null == response) {
                        return true;
                    }

                    List<SeatBid> seatBidList = response.getSeat_bid();
                    if (CollectionUtils.isEmpty(seatBidList)) {
                        return true;
                    }

                    seatBidList.removeIf(seatBid -> {
                        List<Bid> bidList = seatBid.getBid();
                        return CollectionUtils.isEmpty(bidList);
                    });
                    return CollectionUtils.isEmpty(seatBidList);
                }
        ).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 1;
    }
}
