package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.Deal;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 优先级过滤
 *
 * @author fgf
 * @date 2023/3/16
 **/
@Slf4j
@Configuration
public class PriorityFilter implements Filter {
    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set<Integer> priorities = deals.stream()
                .filter(deal -> Objects.nonNull(deal.getDispatcher()))
                .map(Deal::getDispatcher)
                .filter(dispatcher -> Objects.nonNull(dispatcher.getReturnPriority()))
                .map(Dispatcher::getReturnPriority)
                .collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(priorities)) {
            return;
        }
        Integer priority = priorities.stream().sorted().findFirst().get();
        Set<Deal> remove = deals.stream().filter(
                deal -> {
                    Dispatcher dispatcher = deal.getDispatcher();
                    if (Objects.isNull(dispatcher)) {
                        return true;
                    }
                    if (Objects.isNull(dispatcher.getReturnPriority())) {
                        return true;
                    }
                    if (dispatcher.getReturnPriority() > priority) {
                        return true;
                    }
                    return false;
                }
        ).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
