package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.warcar.utils.UrlHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;

/**
 * 落地页302处理
 *
 * @author fgf
 * @date 2023/4/14
 **/
@Component
public class Click302Handler implements MonitorHandler {
    /**
     * 点击监测链接，多个，URL编码
     */
    public static final String C_M_URLS = "__c_m_urls__";
    /**
     * 点击目标地址，单个，URL编码
     */
    public static final String C_T_URL = "__c_t_url__";
    /**
     * 分隔符
     */
    public static final String SPLIT_FOR_CMURLS = "||";

    private final AdxProperties adxProperties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public Click302Handler(AdxProperties adxProperties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.adxProperties = adxProperties;
        this.macrosHandler = macrosHandler;
    }

    @Override
    public void handler(Bid bid, BuildAttribute attribute) {
        //clickthroughurl302
        String mediaId = attribute.getMediaId();
        boolean needClickMonitor = needClickMonitorByMedia(mediaId);
        if (needClickMonitor) {
            String clickThroughUrl302 = buildClickUrl302(bid, attribute, needClickMonitor);
            bid.setClick_through_url_302(clickThroughUrl302);
        }
        // FIXME: 2023/4/27 有服务端上报之后这块需要修改
        //需要监控head的广告位使用302，先请求到服务器获取head；
//        List<String> positions = adxProperties.getHeadMonitorPositions();
//        if (CollectionUtils.isNotEmpty(positions)) {
//            String positionId = AdxContextFactory.get().getPosition().getPositionId();
//            if (positions.contains(positionId)) {
//                bid.setClick_through_url(clickThroughUrl302);
//            }
//        }
//        List<String> headMonitorMediaIds = adxProperties.getHeadMonitorMedia();
//        if (CollectionUtils.isNotEmpty(headMonitorMediaIds)) {
//            if (headMonitorMediaIds.contains(mediaId)) {
//                bid.setClick_through_url(clickThroughUrl302);
//            }
//        }
    }

    @Override
    public int getOrder() {
        return 2;
    }

    private boolean needClickMonitorByMedia(String mediaId) {
        if (StringUtils.isNotEmpty(mediaId)) {
            AdxConstants.Media media = AdxConstants.Media.of(Integer.parseInt(mediaId));
            if (AdxConstants.Media.Bes == media) {
                return true;
            }
        }
        return false;
    }

    private String buildClickUrl302(Bid bid, BuildAttribute buildAttribute, boolean needClickMonitor) {
        String url = adxProperties.getAdsCounter().getAdx302Url(true, false);
        String replacedUrl = macrosHandler.replaceAll(url, buildAttribute);

        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(replacedUrl);
        builder.replaceQueryParam(C_T_URL, getCtUrl(bid.getClick_through_url()));
        if (needClickMonitor) {
            builder.replaceQueryParam(C_M_URLS, getCmUrls(bid.getClick_monitors()));
        }

        return builder.build().toString();
    }

    private String getCmUrls(List<ClickMonitor> clickMonitors) {
        StringBuilder s = new StringBuilder();
        for (ClickMonitor clickMonitor : clickMonitors) {
            s.append(clickMonitor.getClick_monitor_url()).append(SPLIT_FOR_CMURLS);
        }
        return UrlHelper.urlEncode(s.toString());
    }

    private String getCtUrl(String clickThroughUrl) {
        if (StringUtils.isNotBlank(clickThroughUrl)) {
            return UrlHelper.urlEncode(clickThroughUrl);
        }
        return clickThroughUrl;
    }
}
