package com.bxm.adx.common.market.monitor;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2022/6/6
 **/
@Configuration
public class MonitorWrapper implements ApplicationListener<ApplicationReadyEvent> {
    private Collection<? extends MonitorHandler> monitorHandlers;
    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map<String, ? extends MonitorHandler> map = event.getApplicationContext().getBeansOfType(MonitorHandler.class);
        monitorHandlers = map.values().stream().sorted(Comparator.comparing(MonitorHandler::getOrder)).collect(Collectors.toList());
    }

    public void monitorWrapper(BidResponse response) {
        BidRequest bidRequest = AdxContextFactory.get().getBidRequest();
        BuildAttribute buildAttribute = new BuildAttribute()
                .setAdxResponse(response)
                .setSspRequest(bidRequest)
                .setMediaId(bidRequest.getMediaId())
                ;
        for (SeatBid seatBid : response.getSeat_bid()) {
            buildAttribute.setDspId(Objects.nonNull(seatBid.getDspId()) ? seatBid.getDspId().toString() : null);
            buildAttribute.setConfigId(Objects.nonNull(seatBid.getConfigId()) ? seatBid.getConfigId().toString() : null);
            for (Bid bid : seatBid.getBid()) {
                buildAttribute.setDTagId(Objects.nonNull(bid.getTag_id()) ? bid.getTag_id() : null);
                for (MonitorHandler handler : monitorHandlers) {
                    handler.handler(bid, buildAttribute);
                }
            }
        }
    }
}
