package com.bxm.adx.common.market.nbr;

import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

import javax.annotation.Resource;

/**
 * @author fgf
 * @date 2023/4/4
 **/
@Aspect
public class NoBidResponseAspect {
    private NoBidResponseService noBidResponseService;

    public NoBidResponseAspect(NoBidResponseService noBidResponseService) {
        this.noBidResponseService = noBidResponseService;
    }

    @Pointcut("this(com.bxm.adx.common.market.exchange.PriorityExchanger) && execution(* exchange(..))")
    public void pointcut() {}

    @AfterReturning(pointcut = "pointcut()" , returning = "returnVal")
    public void afterReturning(JoinPoint point, Object returnVal) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof PriorityExchanger)) {
            return;
        }
        if (!(returnVal instanceof ExchangeResult)) {
            return;
        }
        ExchangeResult result = (ExchangeResult) returnVal;
        noBidResponseService.handler(result);
    }
}
