package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.market.filter.Filter;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ClassUtils;

import java.util.Map;

/**
 * @author fgf
 * @date 2023/3/8
 **/
@Slf4j
public class ExchangeMicroMeter implements MeterBinder {
    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Map<Class, Counter> counters = Maps.newConcurrentMap();
    private final Iterable<Exchanger> exchangers;

    public ExchangeMicroMeter(Iterable<Exchanger> exchangers) {
        this.exchangers = exchangers;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (Exchanger exchanger : exchangers) {
            Class<?> clazz = ClassUtils.getUserClass(exchanger);
            Timer timer = Timer.builder("exchange.timer").tag("name", clazz.getName()).register(registry);
            timers.put(clazz, timer);
            Counter counter = Counter.builder("exchange.buyer.counter").tag("name", clazz.getName()).register(registry);
            counters.put(clazz, counter);
            log.info("Registering exchange {} meter successful.", exchanger);
        }
    }

    Timer getTimer(Exchanger exchanger) {
        return timers.get(ClassUtils.getUserClass(exchanger));
    }

    Counter getCounter(Exchanger exchanger) {
        return counters.get(ClassUtils.getUserClass(exchanger));
    }
}
