package com.bxm.adx.common.openlog.listener.external;

import com.bxm.adx.common.openlog.event.external.AdClickEvent;
import com.bxm.adx.common.report.ReportType;
import com.bxm.adx.common.report.ServerReportConfig;
import com.bxm.adx.common.report.ServerReportService;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Adx;
import com.bxm.openlog.sdk.params.PublicParam;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.Objects;

/**
 * @author fgf
 * @date 2023/4/19
 **/
@Slf4j
public class AdClickForServerReportEventListener implements EventListener<AdClickEvent> {
    private final ServerReportService serverReportService;

    public AdClickForServerReportEventListener(ServerReportService serverReportService) {
        this.serverReportService = serverReportService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        KeyValueMap map = event.getLog();
        String bidId = map.getFirst(Adx.Param.BIDID);
        String dspId = map.getFirst(Adx.Param.DSPID);
        String mediaId = map.getFirst(Adx.Param.MEDID);
        String appId = map.getFirst(Adx.Param.APPID);

        ServerReportConfig config = serverReportService.getConfig(mediaId, appId, dspId, bidId);
        if (Objects.isNull(config)) {
            return;
        }
        MultiValueMap<String, String> headers = new LinkedMultiValueMap<>();
        headers.add("User-Agent", map.getFirst(PublicParam.UA));
        serverReportService.report(ReportType.CLICK, bidId, headers);
    }
}
