package com.bxm.adx.common.pushable;

import com.bxm.adx.common.AdxProperties;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.warcar.integration.pushable.CachePushableBus;
import com.bxm.warcar.integration.pushable.message.CachePushableMessageListener;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.alions.AlionsConsumer;
import com.bxm.warcar.mq.autoconfigure.AbstractConsumerBeanFactory;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * 缓存推送消费者
 *
 * @author allen
 * @since 2019-12-27
 */
@Configuration
@EnableConfigurationProperties({AlionsPropsConfiguration.class})
public class AdxPushableConsumer extends CachePushableMessageListener {
    private final AdxProperties properties;
    @Bean
    public AbstractConsumerBeanFactory abstractConsumerBeanFactory(AlionsPropsConfiguration alionsPropsConfiguration) {
        return new AbstractConsumerBeanFactory() {
            @Override
            protected Consumer create(String consumerId, Listener messageListener) {
                Properties config = alionsPropsConfiguration.getConfig();
                return new AlionsConsumer(properties.getMessage().getGroupId(), config, messageListener);
            }
        };
    }

    public AdxPushableConsumer(CachePushableBus cachePushableBus, AdxProperties properties) {
        super(CachePushableTopicEnum.DEFAULT.getName() + properties.getMessage().getTopicSuffix(), properties.getMessage().getGroupId(), cachePushableBus);
        this.properties = properties;
    }
}
