package com.bxm.adx.common.report;

import io.micrometer.core.instrument.binder.MeterBinder;
import org.apache.http.Header;
import org.springframework.util.MultiValueMap;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;

/**
 * @author fgf
 * @date 2023/4/19
 **/
public interface ReportClient extends MeterBinder, Closeable {
    /**
     * 发送一个同步的日志请求
     * @param url 完整的URL
     * @return 埋点服务器是否成功接收
     * @throws IOException 网络异常
     */
    boolean request(String url, Header... headers) throws IOException;

    /**
     * 发送一个异步的日志请求
     * @param url 完整的URL
     */
    void asyncRequest(String url, Header... headers);

    /**
     * 发送一个异步的日志请求
     * @param url 完整的URL
     * @param fallback 埋点服务器接收失败后的回调
     */
    void asyncRequest(String url, Consumer<ReportFallback> fallback, Header... headers);

    /**
     * 返回异步队列当前长度
     * @return 等待执行的数量
     */
    int queueSize();

    @Override
    void close();
}
