package com.bxm.adx.common.revealbottom;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.positionassembly.PositionAssembly;
import com.bxm.adx.common.buy.positionassembly.PositionAssemblyService;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Impression;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 兜底<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/17 11:41
 */
@Slf4j
@Primary
@Configuration
public class DefaultRevealBottomImpl implements RevealBottom{

    private final PluginHolder pluginHolder;
    private final PositionService positionService;
    private final PositionAssemblyService positionAssemblyService;

    protected DefaultRevealBottomImpl(PluginHolder pluginHolder, PositionService positionService,
                                      PositionAssemblyService positionAssemblyService) {
        this.pluginHolder = pluginHolder;
        this.positionService = positionService;
        this.positionAssemblyService = positionAssemblyService;
    }

    @Override
    public Buyer getBuyer(RevealBottomDsp revealBottomDsp) {
        Map<String, Buyer> buyers = pluginHolder.getBuyers();
        return buyers.get(revealBottomDsp.getDspCode());
    }

    @Override
    public List<Deal> exchange(MarketOrders orders){
        if (null == orders.getBidRequest() || null == orders.getPositions()) {
            return Collections.emptyList();
        }
        BidRequest request = orders.getBidRequest();
        List<Position> positions = orders.getPositions();
        
        List<Impression> imps = Lists.newArrayList(request.getImps());
        final BidRequest bidRequest = new BidRequest();
        BeanUtils.copyProperties(request, bidRequest);
        bidRequest.setImps(imps);
        // 需要兜底广告位列表
        Map<String, Position> positionMap = new HashMap<>();
        for (Position position : positions) {
            if(position.isRevealBottomAssembly()){
                //是否开启并配置了变现组件
                PositionAssembly positionAssembly = positionAssemblyService.getByPositionId(position.getPositionId());
                if(null != positionAssembly && positionAssembly.isEnable()){
                    positionMap.put(position.getAppPositionId(), position);
                }
            }
        }
        imps.removeIf(imp -> {
            Position position = positionMap.get(imp.getTag_id());
            if(null != position){
                //转换成变现猫的广告位ID
                imp.setTag_id(position.getPositionId());
                return false;
            }else{
                return true;
            }
        });

        if(CollectionUtils.isEmpty(imps)){
            return Collections.emptyList();
        }
        RevealBottomDsp revealBottomDsp = RevealBottomDsp.BXM_ASSEMBLY;
        return getDeal(bidRequest, revealBottomDsp);
    }

    /**
     * 获取兜底DSP内容
     */
    private List<Deal> getDeal(BidRequest bidRequest, RevealBottomDsp revealBottomDsp) {
        Buyer buyer = getBuyer(revealBottomDsp);
        BuyModelAdapter modelAdapter = buyer.getModelAdapter();
        if (null == modelAdapter) {
            log.warn("BuyModelAdapter [{}] not found!", revealBottomDsp.getDspCode());
            return null;
        }
        byte[] request = modelAdapter.buildRequest(bidRequest);
        byte[] response = buyer.offer(request);
        return Lists.newArrayList(new Deal(buyer, request, response, bidRequest));
    }
}
