package com.bxm.adx.common.rule;

import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.util.Set;

/**
 * @author fgf
 * @date 2023/3/17
 **/
@Slf4j
public class AndOrSetRule {
    private final static String OR_SPLIT = "/";
    private final static String AND_SPLIT = ",";

    private final Rule rule;
    private final String andSeparatorChars;
    private final String orSeparatorChars;

    public AndOrSetRule(Rule rule) {
        this(rule, AND_SPLIT, OR_SPLIT);
    }

    public AndOrSetRule(Rule rule, String andSeparatorChars, String orSeparatorChars) {
        this.rule = rule;
        this.andSeparatorChars = andSeparatorChars;
        this.orSeparatorChars = orSeparatorChars;
    }

    public Set<String> getAndParamNameSet() {
        String val = rule.getRuleValue();
        if (StringUtils.isEmpty(val)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(val.split(andSeparatorChars));
    }

    public Set<String> getOrParamNameSet(String val) {
        if (StringUtils.isEmpty(val)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(val.split(orSeparatorChars));
    }

    public boolean isOrParams(String val) {
        if (StringUtils.isEmpty(val)) {
            return false;
        }
        return val.contains(orSeparatorChars);
    }
}
