package com.bxm.adx.common.sdkconfig;

import com.bxm.adx.facade.model.position.SdkConfigResponse;
import com.bxm.mccms.facade.model.pushable.PositionSdkRoundsCacheVO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * sdk轮次响应类<br/>
 *
 * @author zhengwangeng
 * @since 2020-8-26
 */
@Data
public class SdkConfigIntegratedResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 开启并行SDK配置：0关闭，1开启
     */
    private Integer isEnableParallelSdkConfig;

    /**
     * 并行配置
     */
    private List<PositionSdkRoundsCacheVO> sdkRoundsList;

    /**
     * 串行配置
     */
    private List<SdkConfigResponse> sdkConfigList;

}
