package com.bxm.adx.common.sdkrounds;

import com.bxm.adx.common.ingetration.UserServiceIntegration;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.mccms.facade.model.pushable.PositionSdkRoundsCacheVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * <p>
 * 广告位SDK轮次服务实现
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-8-26
 */
@Slf4j
@Configuration
public class SdkRoundsServiceImpl implements SdkRoundsService {
    
    private final SdkRoundsDao sdkRoundsDao;
    private final PositionService positionService;
    private final UserServiceIntegration userService;

    public SdkRoundsServiceImpl(SdkRoundsDao sdkRoundsDao, PositionService positionService,
                                UserServiceIntegration userService) {
        this.sdkRoundsDao = sdkRoundsDao;
        this.positionService = positionService;
        this.userService = userService;
    }

    @Override
    public SdkRoundsResponse getByPositionId(SdkRoundsRequest sdkRoundsRequest, Position position) {
        SdkRoundsResponse sdkRoundsResponse = new SdkRoundsResponse();

        String positionId = sdkRoundsRequest.getPositionId();
        if (null == position) {
            position = positionService.getByPositionId(positionId);
            if (null == position) {
                if (log.isDebugEnabled()) {
                    log.debug("广告位SDK轮次中，没有获取到：{} 的广告位信息。", positionId);
                }
                return sdkRoundsResponse;
            }
        }

        List<PositionSdkRoundsCacheVO> list = sdkRoundsDao.getByPositionId(positionId);
        if (CollectionUtils.isEmpty(list)) {
            if (log.isDebugEnabled()) {
                log.debug("广告位SDK轮次中，没有获取到：{} 的广告位的轮次信息。", positionId);
            }
            return sdkRoundsResponse;
        }
        sdkRoundsResponse.setPositionId(positionId);
        sdkRoundsResponse.setSdkRoundsList(list);
        return sdkRoundsResponse;

    }
}
