package com.bxm.adx.common.sell.builder.macros;

/**
 * 字符串类型的宏参替换处理器
 *
 * @author allen
 * @date 2021-06-22
 * @since 1.0
 */
public interface StringMacrosHandler<T> {

    /**
     * 替换 {@code string} 的宏参
     * @param string 字符串
     * @param attribute 属性对象
     * @return 替换后的字符串
     */
    String replaceAll(String string, T attribute);

    /**
     * 替换 {@code string} 的宏参
     *
     * <p>示例</p>
     * <code> replaceAll("?id=__ID__&name=__NAME__", new T(), "__ID__")</code>
     *
     * <p>返回：<code>"?id=__ID__&name=value"</code></p>
     * @param string 字符串
     * @param attribute 属性对象
     * @param excludes 不替换的宏参，保留原样。比如传入：__ID__，那么不会替换这个宏，但是参数依然保留。
     * @return 替换后的字符串
     */
    String replaceAll(String string, T attribute, String...excludes);
}
