package com.bxm.adx.common.sell.position.verify;

import com.bxm.adx.common.sell.app.AppService;
import com.bxm.adx.common.sell.position.Position;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * Created by Arei on 2020/12/14.
 */
@Slf4j
@Component
public class AppVerify extends AbstractVerify {
    private final AppService appService;

    public AppVerify(AppService appService) {
        this.appService = appService;
    }

    @Override
    public void verify(Context context) {
        if (context.isResult()) {
            return;
        }
        Position position = context.getPosition();
        String appId = position.getAppId();
        com.bxm.adx.facade.rule.app.App app = appService.getAppById(appId);
        if (app == null) {
            if (log.isDebugEnabled()) {
                log.debug("pid = {}, app is null", position.getPositionId());
            }
            return;
        }
        String aid = context.getAppId();
        if (!StringUtils.isEmpty(context.getSdkVer()) && isNeedVerifyAppId(context.getSdkVer())) {
            if (StringUtils.isEmpty(aid)) {
                if (log.isDebugEnabled()) {
                    log.debug("pid = {}, aid is null", position.getPositionId());
                }
                return;
            }
            if (!appId.equalsIgnoreCase(aid)) {
                if (log.isDebugEnabled()) {
                    log.debug("pid = {}, appid is unequal", position.getPositionId());
                }
                return;
            }
        }

        String packageName = context.getPackageName();
        String appPackageName = app.getAppPackageName();
        if (StringUtils.isEmpty(appPackageName)){
            if (log.isWarnEnabled()) {
                log.warn("pid = {}, appPackageName is null", position.getPositionId());
            }
            return;
        }

        if (!appPackageName.equalsIgnoreCase(packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("pid = {}, packageName is unequal", position.getPositionId());
            }
            return;
        }

        context.setResult(true);
        return;
    }
}
