package com.bxm.adx.common.sell.rebuild.request;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author zhangdong
 * @date 2022/12/13
 */
//@RestController
@Deprecated
public class RebuildRequestCustomDataHandler implements RebuildRequestHandler {

    @Autowired
    private AdxProperties adxProperties;
    @Autowired
    private Fetcher fetcher;
    @Autowired
    private Updater updater;

    private final ConcurrentHashMap<Long, Double> map = new ConcurrentHashMap<>();

    @GetMapping("/customPriceCoefficient")
    public ResultModel customPriceCoefficient(@RequestParam("dspId") Long dspId, @RequestParam("coefficient")
            Double coefficient) {
        if (dspId < 0 || coefficient < 0 || coefficient > 1) {
            return ResultModelFactory.FAILED400("参数错误");
        }
        //数据存到redis
        updater.update(getKey(dspId), coefficient);
        return ResultModelFactory.SUCCESS();
    }

    private KeyGenerator getKey(Long dspId) {
        return () -> KeyBuilder.build("ADX", "REQUEST", "CUSTOM", "COEFFICIENT", dspId);
    }


    @PostConstruct
    public void init() {
        List<Long> customPriceCoefficient = adxProperties.getCustomPriceCoefficient();
        if (CollectionUtils.isEmpty(customPriceCoefficient)) {
            return;
        }
        for (Long dspId : customPriceCoefficient) {
            map.put(dspId, -1d);
        }
        schedule();
    }

    @Override
    public void handler(Dispatcher dispatcher, BidRequest request) {
        Long dspId = dispatcher.getDspId();
        Double priceCoefficient = map.get(dspId);
        if (priceCoefficient == null || priceCoefficient < 0) {
            return;
        }
        request.setDspPriceCoefficient(priceCoefficient);
    }

    @Scheduled(cron = "0 */1 * * * ?")
    public void schedule() {
        for (Map.Entry<Long, Double> entry : map.entrySet()) {
            Double fetch = fetcher.fetch(getKey(entry.getKey()), Double.class);
            if (fetch == null) {
                fetch = -1d;
            }
            map.put(entry.getKey(), fetch);
        }
    }


    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
