package com.bxm.adx.common.sell.request;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author arei
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Impression implements Serializable {
    /**
     * 竞价请求广告位唯一标识，竞价系统提供
     */
    private String id;
    /**
     * 广告位ID
     */
    private String tag_id;
    /**
     * 素材要求详情
     */
    @JSONField(name = "native")
    private Native a_native;
    private Integer instl;
    /**
     * 底价/分
     */
    private BigDecimal bid_floor;
    /**
     * 最高价/分
     */
    private BigDecimal bid_top;
    private Integer secure;
    /**
     * 是否支持下载类型，0表示不支持下载类，1表示支持下载类
     */
    private Integer download;
    /**
     * 是否支持deeplink；0表示不支持，1表示支持，默认不支持
     */
    private Integer support_deep_link;
    private Integer num;
    /**
     * 广告位宽
     */
    private Integer w;
    /**
     * 广告位高
     */
    private Integer h;
    private String ext;
    /**
     * Type广告创意类型
     * @see com.bxm.adx.common.AdxConstants.Type
     */
    private Integer type;
    /**
     * 广告位类型（场景）
     * @see com.bxm.adx.common.PositionSceneTypeEnum
     */
    private Integer imp_type;
    /**
     * 0 - 不支持，1 – 支持厂商应用商店下载类广告。等于1时可能返回厂商应用商店下载类广告
     */
    private Integer support_app_store;
    /**
     * 1 - 支持快应用广告。
     * 0 - 不支持快应用广告。
     */
    private Integer support_quick_app;
}
