package com.bxm.adx.common.sell.response;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author fgf
 * @date 2021/9/6
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DownloadInfo implements Serializable {
    public static final Byte ANDROID = 1;
    public static final Byte IOS = 2;
    /**
     * 下载地址
     */
    @JSONField(name = "download_url")
    private String downloadUrl;

    /**
     * 应用名称
     */
    @JSONField(name = "app_name")
    private String appName;

    /**
     * 应用包名
     */
    @JSONField(name = "app_package_name")
    private String appPackageName;

    /**
     * 应用介绍
     */
    @JSONField(name = "app_desc")
    private String appDesc;

    /**
     * 应用大小
     */
    @JSONField(name = "app_size")
    private BigDecimal appSize;

    /**
     * 开发者名称
     */
    @JSONField(name = "developer_name")
    private String developerName;

    /**
     * 版本号
     */
    @JSONField(name = "version")
    private String version;

    /**
     * 隐私协议URL
     */
    @JSONField(name = "privacy_agreement_url")
    private String privacyAgreementUrl;

    /**
     * 用户权限URL
     */
    @JSONField(name = "user_rights_url")
    private String userRightsUrl;

    /**
     * 试玩时长
     */
    @JSONField(name = "trial_time")
    private Integer trialTime;

    /**
     * deeplink地址
     */
    @JSONField(name = "deeplink_url")
    private String deeplinkUrl;

    /**
     * 应用Icon
     */
    @JSONField(name = "app_icon_url")
    private String appIconUrl;
    /**
     * 系统类型：1-安卓，2-IOS
     */
    @JSONField(name = "os_type")
    private Byte osType;
}
