package com.bxm.adx.common.sentinel;

import com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.Tag;

/**
 * @author allen
 * @date 2022-07-21
 * @since 1.0
 */
public class TestMetricExtension implements MetricExtension {

    @Override
    public void addPass(String resource, int n, Object... args) {

    }

    @Override
    public void addBlock(String resource, int n, String origin, BlockException blockException, Object... args) {
        if (blockException instanceof SystemBlockException) {
            SystemBlockException systemBlockException = (SystemBlockException) blockException;
            String limitType = systemBlockException.getLimitType();
            TestMeter.registry.counter("adx.block", Lists.newArrayList(Tag.of("type", limitType))).increment();
        }
    }

    @Override
    public void addSuccess(String resource, int n, Object... args) {

    }

    @Override
    public void addException(String resource, int n, Throwable throwable) {

    }

    @Override
    public void addRt(String resource, long rt, Object... args) {

    }

    @Override
    public void increaseThreadNum(String resource, Object... args) {

    }

    @Override
    public void decreaseThreadNum(String resource, Object... args) {

    }
}
