/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.autoconfigure;

import com.bxm.adx.common.DispatcherFlowProperties;
import com.bxm.adx.common.buy.dispatcher.DefaultDispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.filter.FlowControlFilter;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@ConditionalOnProperty(prefix="adx", value={"enable-dispatcher-control"}, havingValue="true")
@EnableConfigurationProperties(value={DispatcherFlowProperties.class})
public class DispatcherFlowControlAutoConfiguration {
    private final DispatcherFlowProperties properties;

    public DispatcherFlowControlAutoConfiguration(DispatcherFlowProperties properties) {
        this.properties = properties;
    }

    @Bean
    public LoadingCacheFetcher dispatcherFlowFetcher(RedisFetcher redisFetcher) {
        return new LoadingCacheFetcher((Fetcher)redisFetcher, this.properties.getCacheTime().intValue(), this.properties.getTimeUnit());
    }

    @Bean
    public DefaultDispatcherFlowControl dispatcherFlowControl(JedisPool jedisPool, @Qualifier(value="dispatcherFlowFetcher") Fetcher fetcher) {
        return new DefaultDispatcherFlowControl(this.properties, jedisPool, fetcher);
    }

    @Bean
    public FlowControlFilter flowControlFilter(DispatcherFlowControl dispatcherFlowControl) {
        return new FlowControlFilter(dispatcherFlowControl);
    }
}

