/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.DispatcherFlowProperties;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import com.bxm.adx.common.utils.DateUtils;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class DefaultDispatcherFlowControl
implements DispatcherABConfigChangeHandler,
DispatcherFlowControl {
    private static final Logger log = LoggerFactory.getLogger(DefaultDispatcherFlowControl.class);
    private final long SLEEP_TIME = 3000L;
    private final CopyOnWriteArraySet<String> flowControlDispatchers = new CopyOnWriteArraySet();
    private final JedisPool jedisPool;
    private final Fetcher fetcher;
    private final DispatcherFlowProperties properties;

    public DefaultDispatcherFlowControl(DispatcherFlowProperties properties, JedisPool jedisPool, Fetcher fetcher) {
        this.jedisPool = jedisPool;
        this.properties = properties;
        this.fetcher = fetcher;
    }

    @Override
    public Integer getPercent(KeyGenerator key) {
        return (Integer)this.fetcher.fetch(new TargetFactory().keyGenerator(key).cls(Integer.class).selector(this.properties.getDb().intValue()).skipNativeCache(this.properties.getSkipNativeCache().booleanValue()).build());
    }

    @Override
    @Scheduled(cron="0 */10 * * * ?")
    public void execute() {
        long start = System.currentTimeMillis();
        String date = LocalDate.now().format(DateUtils.FORMAT_SIMPLE);
        for (String partKey : this.flowControlDispatchers) {
            try {
                Jedis jedis = this.jedisPool.getResource();
                Throwable throwable = null;
                try {
                    jedis.select(this.properties.getDb().intValue());
                    String previewKey = CacheKeys.DispatcherFlow.baseFlow(date);
                    ScanParams params = new ScanParams().match(KeyBuilder.build((Object[])new Object[]{previewKey, partKey, "*"})).count(this.properties.getPipelineCount());
                    String cursor = "0";
                    do {
                        ScanResult result = jedis.scan(cursor, params);
                        cursor = result.getStringCursor();
                        try (Pipeline pipeline = jedis.pipelined();){
                            List keys = result.getResult();
                            List<Object> flowControlList = this.pipelineGetResponse(pipeline, keys);
                            List<String> percentKeys = this.getPercentKeys(keys);
                            List<Object> percentList = this.pipelineGetResponse(pipeline, percentKeys);
                            List<Object> cutResponse = this.cutting(pipeline, flowControlList, percentKeys, percentList);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("pipeline keys {}, response {}", percentKeys, cutResponse);
                        }
                    } while (!cursor.equals("0"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jedis == null) continue;
                    if (throwable != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jedis.close();
                }
            }
            catch (Exception e) {
                log.error("err", (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        if (end - start < 3000L) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private List<Object> cutting(Pipeline pipeline, List<Object> flowControlList, List<String> percentKeys, List<Object> percentList) {
        Long cr = this.properties.getCr();
        Integer expire = this.properties.getExpire();
        for (int i = 0; i < flowControlList.size(); ++i) {
            String cut = flowControlList.get(i).toString();
            String percentKey = percentKeys.get(i);
            Object old = percentList.get(i);
            if ("1".equals(String.valueOf(cut))) {
                if (!this.outOfBounds(true, old)) {
                    pipeline.incrBy(percentKey, cr.longValue());
                }
            } else if (!this.outOfBounds(false, old)) {
                pipeline.decrBy(percentKey, cr.longValue());
            }
            pipeline.expire(percentKey, expire.intValue());
        }
        List percentResponse = pipeline.syncAndReturnAll();
        return percentResponse;
    }

    private boolean outOfBounds(boolean isCeiling, Object old) {
        try {
            if (isCeiling) {
                if (Objects.isNull(old)) {
                    return false;
                }
                Integer oldVal = Integer.valueOf(String.valueOf(old));
                return oldVal.compareTo(90) >= 0;
            }
            if (Objects.isNull(old)) {
                return true;
            }
            Integer oldVal = Integer.valueOf(String.valueOf(old));
            return oldVal.compareTo(0) <= 0;
        }
        catch (Exception e) {
            log.error("bounds err", (Throwable)e);
            return false;
        }
    }

    private List<Object> pipelineGetResponse(Pipeline pipeline, List<String> keys) {
        for (String key : keys) {
            pipeline.get(key);
        }
        return pipeline.syncAndReturnAll();
    }

    private List<String> getPercentKeys(List<String> keys) {
        ArrayList percentKeys = Lists.newArrayListWithCapacity((int)keys.size());
        for (String key : keys) {
            percentKeys.add(this.percentKey(key));
        }
        return percentKeys;
    }

    private String percentKey(String key) {
        String base = CacheKeys.DispatcherFlow.baseFlow("");
        String[] params = key.split(base);
        return CacheKeys.DispatcherFlow.basePercent(params[1]);
    }

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }
            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) continue;
                for (Dispatcher dispatcher : dispatchers) {
                    Byte flowSwitch;
                    if (!dispatcher.isOpened() || !Objects.nonNull(flowSwitch = dispatcher.getChopQuantitySwitch()) || 1 != flowSwitch) continue;
                    this.flowControlDispatchers.add(this.getPartKey(dispatcher));
                }
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        List<DispatcherConfig> dispatcherConfigs = old.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(dispatcherConfigs)) {
            return;
        }
        for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
            List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
            if (CollectionUtils.isEmpty(dispatchers)) continue;
            for (Dispatcher dispatcher : dispatchers) {
                this.flowControlDispatchers.remove(this.getPartKey(dispatcher));
            }
        }
    }

    private String getPartKey(Dispatcher dispatcher) {
        return KeyBuilder.build((Object[])new Object[]{dispatcher.getDspId(), dispatcher.getDspAppid(), dispatcher.getDspPosid(), dispatcher.getPositionId()});
    }
}

