/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.mccms.facade.model.pushable.DispatcherAbCacheVO;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CachePush(value="DISPATCHERAB")
@Component
public class DispatcherAB
implements Pushable {
    private static final Logger log = LoggerFactory.getLogger(DispatcherAB.class);
    private final Updater updater;
    private final DataSyncProducer dataSyncProducer;

    public DispatcherAB(Updater updater, DataSyncProducer dataSyncProducer) {
        this.updater = updater;
        this.dataSyncProducer = dataSyncProducer;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        DispatcherAbCacheVO dispatcherAbCacheVO;
        Object o = parameters.get("positionId");
        if (Objects.isNull(o)) {
            if (log.isInfoEnabled()) {
                log.info("DISPATCHERAB push err: POSITION_ID is null");
            }
            return;
        }
        String positionId = Objects.toString(o);
        if (log.isInfoEnabled()) {
            log.info("DISPATCHERAB push {} : {}", (Object)positionId, (Object)new String(data));
        }
        if ((dispatcherAbCacheVO = (DispatcherAbCacheVO)JsonHelper.convert((byte[])data, DispatcherAbCacheVO.class)) == null) {
            return;
        }
        String key = dispatcherAbCacheVO.getClass().getName() + "$" + dispatcherAbCacheVO.getPositionId();
        this.dataSyncProducer.post(key, (Object)dispatcherAbCacheVO);
        this.updater.remove(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId));
    }
}

