/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Impression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class DispatcherContext<T extends Id> {
    private BidRequest request;
    private Position position;
    private Collection<T> values;
    private Boolean sdkConcurrentModel;
    private Set<String> userCrowds;

    public boolean getSdkConcurrentModel() {
        if (Objects.isNull(this.sdkConcurrentModel)) {
            this.sdkConcurrentModel = this.initSdkConcurrentModel();
        }
        return this.sdkConcurrentModel;
    }

    private boolean initSdkConcurrentModel() {
        Impression impression = this.request.getImps().iterator().next();
        BigDecimal minPrice = impression.getBid_floor();
        BigDecimal maxPrice = impression.getBid_top();
        return Objects.nonNull(minPrice) && Objects.nonNull(maxPrice) && maxPrice.compareTo(BigDecimal.ZERO) > 0;
    }

    DispatcherContext(BidRequest request, Position position, Collection<T> values, Boolean sdkConcurrentModel, Set<String> userCrowds) {
        this.request = request;
        this.position = position;
        this.values = values;
        this.sdkConcurrentModel = sdkConcurrentModel;
        this.userCrowds = userCrowds;
    }

    public static <T extends Id> DispatcherContextBuilder<T> builder() {
        return new DispatcherContextBuilder();
    }

    public BidRequest getRequest() {
        return this.request;
    }

    public Position getPosition() {
        return this.position;
    }

    public Collection<T> getValues() {
        return this.values;
    }

    public Set<String> getUserCrowds() {
        return this.userCrowds;
    }

    public void setRequest(BidRequest request) {
        this.request = request;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setValues(Collection<T> values) {
        this.values = values;
    }

    public void setSdkConcurrentModel(Boolean sdkConcurrentModel) {
        this.sdkConcurrentModel = sdkConcurrentModel;
    }

    public void setUserCrowds(Set<String> userCrowds) {
        this.userCrowds = userCrowds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DispatcherContext)) {
            return false;
        }
        DispatcherContext other = (DispatcherContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSdkConcurrentModel() != other.getSdkConcurrentModel()) {
            return false;
        }
        BidRequest this$request = this.getRequest();
        BidRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        Position this$position = this.getPosition();
        Position other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Collection<T> this$values = this.getValues();
        Collection<T> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Set<String> this$userCrowds = this.getUserCrowds();
        Set<String> other$userCrowds = other.getUserCrowds();
        return !(this$userCrowds == null ? other$userCrowds != null : !((Object)this$userCrowds).equals(other$userCrowds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DispatcherContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getSdkConcurrentModel() ? 79 : 97);
        BidRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        Position $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Collection<T> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Set<String> $userCrowds = this.getUserCrowds();
        result = result * 59 + ($userCrowds == null ? 43 : ((Object)$userCrowds).hashCode());
        return result;
    }

    public String toString() {
        return "DispatcherContext(request=" + this.getRequest() + ", position=" + this.getPosition() + ", values=" + this.getValues() + ", sdkConcurrentModel=" + this.getSdkConcurrentModel() + ", userCrowds=" + this.getUserCrowds() + ")";
    }

    public static class DispatcherContextBuilder<T extends Id> {
        private BidRequest request;
        private Position position;
        private Collection<T> values;
        private Boolean sdkConcurrentModel;
        private Set<String> userCrowds;

        DispatcherContextBuilder() {
        }

        public DispatcherContextBuilder<T> request(BidRequest request) {
            this.request = request;
            return this;
        }

        public DispatcherContextBuilder<T> position(Position position) {
            this.position = position;
            return this;
        }

        public DispatcherContextBuilder<T> values(Collection<T> values) {
            this.values = values;
            return this;
        }

        public DispatcherContextBuilder<T> sdkConcurrentModel(Boolean sdkConcurrentModel) {
            this.sdkConcurrentModel = sdkConcurrentModel;
            return this;
        }

        public DispatcherContextBuilder<T> userCrowds(Set<String> userCrowds) {
            this.userCrowds = userCrowds;
            return this;
        }

        public DispatcherContext<T> build() {
            return new DispatcherContext<T>(this.request, this.position, this.values, this.sdkConcurrentModel, this.userCrowds);
        }

        public String toString() {
            return "DispatcherContext.DispatcherContextBuilder(request=" + this.request + ", position=" + this.position + ", values=" + this.values + ", sdkConcurrentModel=" + this.sdkConcurrentModel + ", userCrowds=" + this.userCrowds + ")";
        }
    }
}

