/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigCaching;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherCached;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherConfigCached;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterFactory;
import com.bxm.adx.common.buy.dispatcher.reorder.DispatcherReorderFactory;
import com.bxm.adx.common.creative.replace.ReplaceCreative;
import com.bxm.adx.common.creative.replace.ReplaceCreativeDao;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class DispatcherServiceImpl
implements DispatcherService {
    private static final Logger log = LoggerFactory.getLogger(DispatcherServiceImpl.class);
    private final ReplaceCreativeDao replaceCreativeDao;
    private final DispatcherConfigCached dispatcherConfigCached;
    private final DispatcherABConfigCaching dispatcherABConfigCaching;
    private final DispatcherCached dispatcherCached;
    private final DispatcherFilterFactory dispatcherFilterFactory;
    private final DispatcherReorderFactory dispatcherReorderFactory;

    public DispatcherServiceImpl(ReplaceCreativeDao replaceCreativeDao, DispatcherConfigCached dispatcherConfigCached, DispatcherABConfigCaching dispatcherABConfigCaching, DispatcherCached dispatcherCached, DispatcherFilterFactory dispatcherFilterFactory, DispatcherReorderFactory dispatcherReorderFactory) {
        this.replaceCreativeDao = replaceCreativeDao;
        this.dispatcherConfigCached = dispatcherConfigCached;
        this.dispatcherABConfigCaching = dispatcherABConfigCaching;
        this.dispatcherCached = dispatcherCached;
        this.dispatcherFilterFactory = dispatcherFilterFactory;
        this.dispatcherReorderFactory = dispatcherReorderFactory;
    }

    @Override
    public Map<Integer, Collection<Dispatcher>> getPriority(Position position, BidRequest bidRequest) {
        TreeMap dsps = Maps.newTreeMap();
        Collection<Dispatcher> dispatchers = this.getDispatchers(position);
        dispatchers = dispatchers.stream().filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getOpened() == 1).collect(Collectors.toSet());
        DispatcherContext<Dispatcher> context = DispatcherContext.builder().values(dispatchers).position(position).request(bidRequest).build();
        this.dispatcherFilterFactory.filter(context);
        dispatchers = this.dispatcherReorderFactory.reorder(context);
        for (Dispatcher dispatcher : dispatchers) {
            int priority = dispatcher.getPriority();
            Collection collection = MapHelper.get(dsps, Integer.valueOf(priority), new ArrayList());
            List<Long> creativeIds = dispatcher.getCreativeIdList();
            if (CollectionUtils.isNotEmpty(creativeIds)) {
                List<ReplaceCreative> creativeList = this.replaceCreativeDao.queryCreativeListByIds(creativeIds);
                dispatcher.setCreativeList(creativeList);
            }
            dispatcher.setDispatcherPriceConfig(this.getPriceConfigByTime(dispatcher));
            collection.add(dispatcher);
        }
        return dsps;
    }

    private Collection<Dispatcher> getDispatchers(Position position) {
        int userBucket;
        Long configId;
        String positionId = position.getPositionId();
        DispatcherABConfig dispatcherABConfig = (DispatcherABConfig)this.dispatcherABConfigCaching.get(positionId);
        if (Objects.isNull(dispatcherABConfig)) {
            return Sets.newHashSet();
        }
        String uid = AdxContextFactory.get().getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            uid = RandomStringUtils.randomAlphabetic((int)13);
        }
        if (Objects.isNull(configId = this.dispatcherConfigCached.getConfigId(positionId, userBucket = AdxUtils.getBucket(uid)))) {
            if (log.isWarnEnabled()) {
                log.warn("position {} user bucket {} fail ", (Object)positionId, (Object)userBucket);
            }
            return Sets.newHashSet();
        }
        AdxContextFactory.get().setConfigId(configId);
        return this.dispatcherCached.getDispatchers(positionId, configId);
    }

    private DispatcherPriceConfig getPriceConfigByTime(Dispatcher dispatcher) {
        List<DispatcherPriceConfig> configs = dispatcher.getDispatcherDspPosPriceConfigVOS();
        if (CollectionUtils.isEmpty(configs)) {
            return null;
        }
        int hour = LocalDateTime.now().get(ChronoField.HOUR_OF_DAY);
        for (DispatcherPriceConfig config : configs) {
            Integer start = config.getStartTime();
            Integer end = config.getEndTime();
            if (!Objects.nonNull(start) || !Objects.nonNull(end) || start > hour || hour >= end) continue;
            return config;
        }
        if (2 == dispatcher.getAvgType()) {
            log.error("dispatcher {} avg-type {} err", (Object)dispatcher.getId(), (Object)dispatcher.getAvgType());
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        log.warn("dispatcher {} avg-type {} err", (Object)dispatcher.getId(), (Object)dispatcher.getAvgType());
        return DispatcherPriceConfig.builder().ltPriceDiscountFactor(BigDecimal.ONE).gtPriceDiscountFactor(BigDecimal.ONE).biddingCoefficient(BigDecimal.ONE).profitMargin(BigDecimal.ZERO).build();
    }
}

