/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import cn.hutool.core.collection.ConcurrentHashSet;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.WhiteBlackSetRule;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.utils.MapHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class AppFilter
implements DispatcherFilter<Dispatcher>,
DispatcherABConfigChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(AppFilter.class);
    private final ConcurrentHashMap<String, Set<String>> appPackageWhite = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> appPackageBlack = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> unlimited = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> white = new ConcurrentHashMap();

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }
            String positionId = latest.getPositionId();
            if (StringUtils.isEmpty((Object)positionId)) {
                return;
            }
            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) continue;
                for (Dispatcher dispatcher : dispatchers) {
                    if (dispatcher.getOpened() == 0) continue;
                    Rule rule = dispatcher.getMediaAppDirect();
                    String id = dispatcher.getId();
                    if (Objects.isNull(rule)) {
                        ((Set)MapHelper.get(this.unlimited, positionId, new ConcurrentHashSet())).add(id);
                        continue;
                    }
                    WhiteBlackSetRule whiteBlackSetRule = new WhiteBlackSetRule(rule);
                    Set<String> values = whiteBlackSetRule.getSet();
                    if (CollectionUtils.isEmpty(values)) {
                        ((Set)MapHelper.get(this.unlimited, positionId, new ConcurrentHashSet())).add(id);
                        continue;
                    }
                    if (whiteBlackSetRule.isWhite()) {
                        ((Set)MapHelper.get(this.white, positionId, new ConcurrentHashSet())).add(id);
                        for (String val : values) {
                            ((Set)MapHelper.get(this.appPackageWhite, this.buildKey(positionId, val), new ConcurrentHashSet())).add(id);
                        }
                        continue;
                    }
                    for (String val : values) {
                        ((Set)MapHelper.get(this.appPackageBlack, this.buildKey(positionId, val), new ConcurrentHashSet())).add(id);
                    }
                }
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        List<DispatcherConfig> dispatcherConfigs = old.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(dispatcherConfigs)) {
            return;
        }
        String positionId = old.getPositionId();
        if (StringUtils.isEmpty((Object)positionId)) {
            return;
        }
        this.unlimited.remove(positionId);
        for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
            List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
            if (CollectionUtils.isEmpty(dispatchers)) continue;
            for (Dispatcher dispatcher : dispatchers) {
                Rule rule = dispatcher.getMediaAppDirect();
                if (Objects.isNull(rule)) continue;
                WhiteBlackSetRule whiteBlackSetRule = new WhiteBlackSetRule(rule);
                Set<String> values = whiteBlackSetRule.getSet();
                if (whiteBlackSetRule.isWhite()) {
                    this.white.remove(positionId);
                    for (String val : values) {
                        this.appPackageWhite.remove(this.buildKey(positionId, val));
                    }
                    continue;
                }
                for (String val : values) {
                    this.appPackageBlack.remove(this.buildKey(positionId, val));
                }
            }
        }
    }

    private String buildKey(String positionId, String appPkg) {
        return positionId + "-" + appPkg;
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        App app = context.getRequest().getApp();
        String packageName = Objects.isNull(app) ? null : app.getBundle();
        String appId = Objects.isNull(app) ? null : app.getId();
        Collection<Dispatcher> dispatchers = context.getValues();
        Set removes = dispatchers.stream().filter(dispatcher -> this.limitedByAppPackageNameV2((Dispatcher)dispatcher, packageName) || this.limitedByAppId((Dispatcher)dispatcher, appId)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    public int getOrder() {
        return 1;
    }

    private boolean limitedByAppPackageNameV2(Dispatcher dispatcher, String packageName) {
        String positionId = dispatcher.getPositionId();
        String id = dispatcher.getId();
        boolean isEmpty = StringUtils.isEmpty((Object)packageName);
        Set<String> whiteRuleDispatcherIds = this.white.get(positionId);
        if (isEmpty) {
            if (CollectionUtils.isEmpty(whiteRuleDispatcherIds)) {
                return false;
            }
            return whiteRuleDispatcherIds.contains(id);
        }
        String key = this.buildKey(positionId, packageName);
        Set<String> whiteSet = this.appPackageWhite.get(key);
        if (CollectionUtils.isNotEmpty(whiteSet) && whiteSet.contains(id)) {
            return false;
        }
        Set<String> blackSet = this.appPackageBlack.get(key);
        if (CollectionUtils.isNotEmpty(blackSet) && blackSet.contains(id)) {
            return true;
        }
        Set<String> unlimitedSet = this.unlimited.get(positionId);
        if (CollectionUtils.isNotEmpty(unlimitedSet) && unlimitedSet.contains(id)) {
            return false;
        }
        return CollectionUtils.isNotEmpty(whiteRuleDispatcherIds) && whiteRuleDispatcherIds.contains(id);
    }

    private boolean limitedByAppPackageName(Dispatcher dispatcher, String packageName) {
        Rule rule = dispatcher.getMediaAppDirect();
        if (Objects.isNull(rule)) {
            return false;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (StringUtils.isEmpty((Object)packageName)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"packageName-white-empty");
                }
                return true;
            }
            if (set.contains(packageName)) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"packageName-white");
            }
            return true;
        }
        if (StringUtils.isEmpty((Object)packageName)) {
            return false;
        }
        if (set.contains(packageName)) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"packageName-black");
            }
            return true;
        }
        return false;
    }

    private boolean limitedByAppId(Dispatcher dispatcher, String appId) {
        Rule rule = dispatcher.getMediaIdDirect();
        if (Objects.isNull(rule)) {
            return false;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (StringUtils.isEmpty((Object)appId)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"appId-white-empty");
                }
                return true;
            }
            if (set.contains(appId)) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"appId-white");
            }
            return true;
        }
        if (StringUtils.isEmpty((Object)appId)) {
            return false;
        }
        if (set.contains(appId)) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"appId-black");
            }
            return true;
        }
        return false;
    }
}

