/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.utils.DateUtils;
import com.bxm.warcar.cache.KeyGenerator;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlFilter
implements DispatcherFilter<Dispatcher> {
    private static final Logger log = LoggerFactory.getLogger(FlowControlFilter.class);
    private final DispatcherFlowControl dispatcherFlowControl;

    public FlowControlFilter(DispatcherFlowControl dispatcherFlowControl) {
        this.dispatcherFlowControl = dispatcherFlowControl;
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Collection<Dispatcher> dispatchers = context.getValues();
        BidRequest request = context.getRequest();
        String date = LocalDate.now().format(DateUtils.FORMAT_SIMPLE);
        Set removes = dispatchers.stream().filter(dispatcher -> {
            KeyGenerator key;
            Integer percent;
            Byte flow = dispatcher.getChopQuantitySwitch();
            if (Objects.nonNull(flow) && 1 == flow && Objects.nonNull(percent = this.dispatcherFlowControl.getPercent(key = this.getKeyGenerator(date, (Dispatcher)dispatcher, request)))) {
                percent = this.fixPercent(key, percent);
                int random = RandomUtils.nextInt((int)0, (int)100);
                if (random < percent) {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    private Integer fixPercent(KeyGenerator keyGenerator, Integer percent) {
        if (percent.compareTo(90) > 0) {
            log.warn("key {}, val {}", (Object)keyGenerator.generateKey(), (Object)percent);
            return 90;
        }
        if (percent.compareTo(0) < 0) {
            log.warn("key {}, val {}", (Object)keyGenerator.generateKey(), (Object)percent);
            return 0;
        }
        return percent;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private KeyGenerator getKeyGenerator(String date, Dispatcher dispatcher, BidRequest request) {
        String dspId = dispatcher.getDspId().toString();
        String dspTagId = dispatcher.getDspPosid();
        String dspAppId = dispatcher.getDspAppid();
        String tagId = request.getImps().iterator().next().getTag_id();
        App app = request.getApp();
        String appPkg = "";
        if (Objects.nonNull(app)) {
            appPkg = Optional.ofNullable(app.getBundle()).orElse("");
        }
        return CacheKeys.DispatcherFlow.getDispatcherFlowPercent(date, dspId, dspAppId, dspTagId, tagId, appPkg);
    }
}

