/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.rule.Rule;
import com.bxm.adx.common.rule.WhiteBlackSetRule;
import com.bxm.adx.common.sell.request.User;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InstalledAppFilter
implements DispatcherFilter<Dispatcher> {
    private static final Logger log = LoggerFactory.getLogger(InstalledAppFilter.class);

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        User user = context.getRequest().getUser();
        List<String> installList = Objects.isNull(user) ? null : user.getInstalled_app_list();
        Collection<Dispatcher> dispatchers = context.getValues();
        Set removes = dispatchers.stream().filter(dispatcher -> this.limitedByInstallAppList((Dispatcher)dispatcher, installList)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    public int getOrder() {
        return 2;
    }

    private boolean limitedByInstallAppList(Dispatcher dispatcher, List<String> installList) {
        Rule rule = dispatcher.getInstalledAppDirect();
        if (Objects.isNull(rule)) {
            return false;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (CollectionUtils.isEmpty(installList)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"installApp-white-empty");
                }
                return true;
            }
            Collection result = CollectionUtils.intersection(installList, set);
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"installApp-white-empty");
            }
            return true;
        }
        if (CollectionUtils.isEmpty(installList)) {
            return false;
        }
        Collection result = CollectionUtils.intersection(installList, set);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"installApp-black");
            }
            return true;
        }
        return false;
    }
}

