/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterCondition;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.sell.request.Impression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@DispatcherFilterCondition(onDmType={2})
public class PriceFilter
implements DispatcherFilter<Dispatcher> {
    private static final Logger log = LoggerFactory.getLogger(PriceFilter.class);

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        if (!context.getSdkConcurrentModel()) {
            return;
        }
        Impression impression = context.getRequest().getImps().iterator().next();
        BigDecimal minPrice = impression.getBid_floor();
        BigDecimal maxPrice = impression.getBid_top();
        Collection<Dispatcher> dispatchers = context.getValues();
        Set removes = dispatchers.stream().filter(dispatcher -> !this.limitedByPrice((Dispatcher)dispatcher, minPrice, maxPrice)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    public int getOrder() {
        return 0;
    }

    private boolean limitedByPrice(Dispatcher dispatcher, BigDecimal min, BigDecimal max) {
        BigDecimal price = dispatcher.getDspAvgPrice();
        if (Objects.isNull(price)) {
            return true;
        }
        if (price.compareTo(min.movePointLeft(2)) == -1) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"< min");
            }
            return true;
        }
        if (price.compareTo(max.movePointLeft(2)) >= 0) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"> max");
            }
            return true;
        }
        return false;
    }
}

