/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.reorder;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.reorder.DispatcherOrderStrategy;
import com.bxm.adx.common.buy.dispatcher.reorder.DispatcherReorder;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DispatcherSdkReorder
implements DispatcherReorder {
    private static final Logger log = LoggerFactory.getLogger(DispatcherSdkReorder.class);
    private final Fetcher fetcher;
    private final Updater updater;

    public DispatcherSdkReorder(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public Collection<Dispatcher> reorder(DispatcherContext<Dispatcher> context) {
        Collection<Dispatcher> dispatchers = context.getValues();
        Optional<Dispatcher> exist = dispatchers.stream().filter(dispatcher -> Objects.nonNull(dispatcher.getFrequency())).findFirst();
        if (!exist.isPresent()) {
            return dispatchers;
        }
        Collection<Object> reorderList = null;
        String positionId = context.getPosition().getPositionId();
        String uid = AdxContextFactory.get().getUid();
        List recordList = this.fetcher.hfetchList(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId), uid, Dispatcher.class);
        reorderList = CollectionUtils.isEmpty((Collection)recordList) ? context.getValues() : recordList;
        reorderList = this.reorderPriorityByFreq(reorderList, uid, positionId);
        return reorderList;
    }

    @Override
    public DispatcherOrderStrategy orderStrategy() {
        return DispatcherOrderStrategy.sdk_common;
    }

    private Collection<Dispatcher> reorderPriorityByFreq(Collection<Dispatcher> ds, String uid, String positionId) {
        HashSet result = Sets.newHashSet();
        List ps = ds.stream().map(Dispatcher::getPriority).sorted().distinct().collect(Collectors.toList());
        Integer max = (Integer)ps.get(ps.size() - 1);
        for (Integer p : ps) {
            Set dispatchers = ds.stream().filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getPriority() == p.intValue()).collect(Collectors.toSet());
            if (dispatchers.size() == 1) {
                Integer used;
                Dispatcher dispatcher = (Dispatcher)dispatchers.iterator().next();
                Integer initFreq = dispatcher.getFrequency();
                if (null != initFreq && (used = Integer.valueOf(this.getPositionDspFreq(dispatcher, uid))) >= initFreq) {
                    if (dispatcher.getPriority() != max.intValue()) {
                        max = max + 1;
                        dispatcher.setPriority(max);
                    }
                    this.resetPositionDspFreq(dispatcher, uid);
                }
                result.add(dispatcher);
                continue;
            }
            result.addAll(dispatchers);
        }
        this.updateReorderDispatcher(uid, positionId, result);
        return result;
    }

    private int getPositionDspFreq(Dispatcher dispatcher, String uid) {
        KeyGenerator keyGenerator = this.getFreqKeyGenerator(dispatcher, uid);
        Long freq = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(freq) ? 0 : freq.intValue();
    }

    private void resetPositionDspFreq(Dispatcher dispatcher, String uid) {
        LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        KeyGenerator keyGenerator = this.getFreqKeyGenerator(dispatcher, uid);
        this.updater.update(keyGenerator, (Object)0, (int)seconds);
    }

    private void updateReorderDispatcher(String uid, String positionId, Collection<Dispatcher> dispatchers) {
        LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        this.updater.hupdate(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId), uid, dispatchers, (int)seconds);
    }

    private KeyGenerator getFreqKeyGenerator(Dispatcher dispatcher, String uid) {
        return AdxKeyGenerator.Counter.getPositionDspFrequency((String)dispatcher.getPositionId(), (String)dispatcher.getConfigId().toString(), (String)dispatcher.getDspId().toString(), (String)uid);
    }
}

