/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dsp;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspChangeHandler;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DspCached
implements DspChangeHandler {
    private final ConcurrentHashMap<String, Dsp> dspCodeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Dsp> dspIdMap = new ConcurrentHashMap();

    @Override
    public void doUpdate(Dsp old, Dsp latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            this.dspIdMap.put(latest.getId(), latest);
            this.dspCodeMap.put(latest.getDspCode(), latest);
        }
    }

    @Override
    public void doDelete(Dsp old) {
        this.dspCodeMap.remove(old.getDspCode());
        this.dspIdMap.remove(old.getId());
    }

    public Collection<Dsp> getAll() {
        return this.dspIdMap.values();
    }

    public Dsp getById(Long id) {
        return this.dspIdMap.get(id);
    }

    public Dsp getByCode(String code) {
        return this.dspCodeMap.get(code);
    }
}

