/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.position;

import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointChangeHandler;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdvertPointCached
implements AdvertPointChangeHandler {
    private final ConcurrentHashMap<String, AdvertPoint> advertPointMap = new ConcurrentHashMap();

    @Override
    public void doUpdate(AdvertPoint old, AdvertPoint latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            this.advertPointMap.put(latest.getUniqueKey(), latest);
        }
    }

    @Override
    public void doDelete(AdvertPoint old) {
        this.advertPointMap.remove(old.getUniqueKey());
    }

    public AdvertPoint getAdPoint(String dspId, String appId, String dspPositionId) {
        return this.advertPointMap.get(AdvertPointCached.getMapKey(dspId, appId, dspPositionId));
    }

    private static String getMapKey(String dspId, String appId, String dspPositionId) {
        return dspId + "-" + appId + "-" + dspPositionId;
    }
}

