/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.position;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointCached;
import com.bxm.adx.common.buy.position.AdvertPointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdvertPointServiceImpl
implements AdvertPointService {
    private static final Logger log = LoggerFactory.getLogger(AdvertPointServiceImpl.class);
    private final AdvertPointCached advertPointCached;
    private final DspService dspService;

    public AdvertPointServiceImpl(AdvertPointCached advertPointCached, DspService dspService) {
        this.advertPointCached = advertPointCached;
        this.dspService = dspService;
    }

    @Override
    public AdvertPoint getAdvertPointByDspId(String dspId, String dspAppId, String dspPositionId) {
        Dsp dsp = this.dspService.get(Long.valueOf(dspId));
        if (dsp.getDspCode().contains("pangu")) {
            return null;
        }
        AdvertPoint advertPoint = this.advertPointCached.getAdPoint(dspId, dspAppId, dspPositionId);
        return advertPoint;
    }
}

