/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.caching;

import com.bxm.adx.common.utils.ChangeUtils;
import com.bxm.adx.common.utils.ChangedEnum;
import java.util.function.Supplier;

public interface ChangedHandler<T> {
    public void doUpdate(T var1, T var2);

    public void doDelete(T var1);

    default public boolean isExecuteUpdateAndDoDelete(T old, T latest) {
        ChangedEnum changedEnum = ChangeUtils.getChanged(old);
        if (ChangedEnum.ADD == changedEnum) {
            return true;
        }
        this.doDelete(old);
        return true;
    }

    default public boolean isExecuteUpdateAndDoDelete(T old, T latest, Supplier<Object> oldNode, Supplier<Object> latestNode) {
        ChangedEnum changedEnum = ChangeUtils.getChanged(old);
        if (ChangedEnum.ADD == changedEnum) {
            return true;
        }
        changedEnum = ChangeUtils.getNodeChanged(oldNode.get(), latestNode.get());
        if (ChangedEnum.NODE_NONE == changedEnum) {
            return false;
        }
        this.doDelete(old);
        return true;
    }
}

