/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.caching.sync;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.bxm.warcar.zk.listener.children.ChildrenChanged;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class DataSyncMutableCacheDispatcher
implements MutableCache,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DataSyncMutableCacheDispatcher.class);
    private final Map<Class<?>, DataSyncHandler> handlers = Maps.newHashMap();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ChildrenChanged childrenChanged = (ChildrenChanged)event.getApplicationContext().getBean(ChildrenChanged.class);
        childrenChanged.init();
        Map beans = event.getApplicationContext().getBeansOfType(DataSyncHandler.class);
        for (Map.Entry entry : beans.entrySet()) {
            DataSyncHandler handler = (DataSyncHandler)entry.getValue();
            this.handlers.put(handler.getClazz(), handler);
            log.info("Registered {}", (Object)handler);
        }
    }

    public synchronized Object set(String key, Object value) throws NullPointerException {
        if (Objects.isNull(key)) {
            log.warn("key is null!");
            return null;
        }
        if (Objects.isNull(value)) {
            log.warn("value is null by key: {}", (Object)key);
            return null;
        }
        Class<?> clazz = value.getClass();
        DataSyncHandler dataSyncHandler = this.handlers.get(clazz);
        if (Objects.isNull(dataSyncHandler)) {
            log.warn("Does not found DataSyncHandler matching class {}", clazz);
            return null;
        }
        return dataSyncHandler.set(key, value);
    }

    public void del(String key) {
    }

    public <T> T get(String key) throws NullPointerException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getAll() {
        throw new UnsupportedOperationException();
    }

    public long size() {
        return -1L;
    }
}

