/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.collection;

import com.bxm.adx.common.collection.PositionCollectionDao;
import com.bxm.mccms.facade.model.pushable.PositionCollectionCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="POSITION_COLLECTION")
public class PositionCollectionDaoImpl
implements PositionCollectionDao,
Pushable {
    private final Fetcher fetcher;
    private final Updater updater;

    public PositionCollectionDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public PositionCollectionCacheVO getByPositionId(String positionId) {
        return (PositionCollectionCacheVO)this.fetcher.fetch(this.getKeyGenerator(positionId), PositionCollectionCacheVO.class);
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get("positionId");
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        PositionCollectionCacheVO sdkConfigList = (PositionCollectionCacheVO)JsonHelper.convert((byte[])data, PositionCollectionCacheVO.class);
        this.updater.update(this.getKeyGenerator(positionId), (Object)sdkConfigList);
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION_COLLECTION", "POSITION_ID", value});
    }
}

